/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.item.ItemBase;
import cofh.core.util.fluid.BucketHandler;
import cofh.lib.render.IFluidOverlayItem;
import cofh.lib.util.RegistryUtils;
import cofh.lib.util.helpers.StringHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class ItemBucket
extends ItemBase
implements IFluidOverlayItem {
    Item container = Items.bucket;

    public ItemBucket() {
        this.setMaxStackSize(1);
        this.setContainerItem(this.container);
        this.itemMap.put((Object)-1000, (Object)new ItemBase.ItemEntry("OverlayIcon"));
    }

    public ItemBucket(String string) {
        super(string);
        this.setMaxStackSize(1);
        this.setContainerItem(this.container);
        this.itemMap.put((Object)-1000, (Object)new ItemBase.ItemEntry("OverlayIcon"));
    }

    public ItemBucket(String string, Item item) {
        super(string);
        this.setMaxStackSize(1);
        this.container = item;
        this.setContainerItem(item);
        this.itemMap.put((Object)-1000, (Object)new ItemBase.ItemEntry("OverlayIcon"));
    }

    @Override
    public void registerIcons(IIconRegister iIconRegister) {
        if (!this.hasTextures) {
            return;
        }
        ItemBase.ItemEntry itemEntry = (ItemBase.ItemEntry)this.itemMap.get((Object)-1000);
        itemEntry.icon = this.registerIcon(iIconRegister, itemEntry);
        for (int i = 0; i < this.itemList.size(); ++i) {
            ItemBase.ItemEntry itemEntry2 = (ItemBase.ItemEntry)this.itemMap.get(this.itemList.get(i));
            itemEntry2.icon = this.registerIcon(iIconRegister, itemEntry2);
        }
    }

    @Override
    protected IIcon registerIcon(IIconRegister iIconRegister, ItemBase.ItemEntry itemEntry) {
        String string = this.modName + ":" + this.getUnlocalizedName().replace("item." + this.modName + ".", "") + "/" + StringHelper.titleCase(itemEntry.name);
        if (RegistryUtils.itemTextureExists(string)) {
            itemEntry.maxDamage = 1;
            return iIconRegister.registerIcon(string);
        }
        itemEntry.maxDamage = 2;
        return iIconRegister.registerIcon("minecraft:bucket_empty");
    }

    public int getRenderPasses(int n) {
        return ((ItemBase.ItemEntry)this.itemMap.get((Object)Integer.valueOf((int)n))).maxDamage;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamageForRenderPass(int n, int n2) {
        if (n2 == 1) {
            return ((ItemBase.ItemEntry)this.itemMap.get((Object)Integer.valueOf((int)-1000))).icon;
        }
        return super.getIconFromDamageForRenderPass(n, n2);
    }

    public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        MovingObjectPosition movingObjectPosition = this.getMovingObjectPositionFromPlayer(world, entityPlayer, false);
        if (movingObjectPosition == null || movingObjectPosition.typeOfHit != MovingObjectPosition.MovingObjectType.BLOCK) {
            return itemStack;
        }
        int n = movingObjectPosition.blockX;
        int n2 = movingObjectPosition.blockY;
        int n3 = movingObjectPosition.blockZ;
        switch (movingObjectPosition.sideHit) {
            case 0: {
                --n2;
                break;
            }
            case 1: {
                ++n2;
                break;
            }
            case 2: {
                --n3;
                break;
            }
            case 3: {
                ++n3;
                break;
            }
            case 4: {
                --n;
                break;
            }
            case 5: {
                ++n;
            }
        }
        if (!entityPlayer.canPlayerEdit(n, n2, n3, movingObjectPosition.sideHit, itemStack) || !world.isAirBlock(n, n2, n3) && world.getBlock(n, n2, n3).getMaterial().isSolid()) {
            return itemStack;
        }
        if (BucketHandler.emptyBucket(world, n, n2, n3, itemStack) && !entityPlayer.capabilities.isCreativeMode) {
            return new ItemStack(this.container);
        }
        return itemStack;
    }
}

